/*
 * @(#)RelationalERDiagram.java  1.0  2006-01-18
 *
 * Copyright (c) 2006 Lucerne University of Applied Sciences and Arts (HSLU)
 * Zentralstrasse 18, Postfach 2858, CH-6002 Lucerne, Switzerland
 * All rights reserved.
 *
 * The copyright of this software is owned by the Lucerne University of Applied 
 * Sciences and Arts (HSLU). You may not use, copy or modify this software, 
 * except in accordance with the license agreement you entered into with HSLU. 
 * For details see accompanying license terms. 
 */

package ch.hslu.cm.rer.diagram;

import ch.hslu.cm.*;
import ch.hslu.cm.rer.model.RelationalERModel;
import ch.hslu.cm.rer.model.Entity;
import ch.hslu.cm.rer.model.Relationship;
import ch.hslu.cm.simulation.*;
import ch.randelshofer.util.*;
import java.awt.*;
import java.awt.geom.*;
import java.util.*;
import javax.swing.*;
/**
 * A Relational Entity-Realationship Diagram.
 * 
 * 
 * @author Werner Randelshofer
 * @version 1.0 2006-01-18  Created.
 */
public class RelationalERDiagram extends AbstractDiagram {
    public final static Color
    ENTITY_CONNECTOR_COLOR = Color.black,
    ENTITY_NAME_COMPARTMENT_COLOR = Color.white,
    ENTITY_ATTRIBUTE_COMPARTMENT_COLOR = Color.white,
    ENTITY_FILL_COLOR = Color.white,
    ENTITY_STROKE_COLOR = Color.black,
    ENTITY_TYPE_COLOR = new Color(0x666666),
    ENTITY_TEXT_COLOR = Color.black,
    ENTITY_SHADOW_COLOR = new Color(0xbbbbbb),
    RELATION_STROKE_COLOR = new Color(0x000099),
    RELATION_FILL_COLOR = Color.white
    ;
    
    public final static int OBJECT_LAYER = 0;
    public final static int LINK_LAYER = 1;
    
    /** Creates a new instance. */
    public RelationalERDiagram() {
        this(new RelationalERModel());
    }
    public RelationalERDiagram(RelationalERModel simulation) {
        setSimulation(simulation);
    }
    public RelationalERModel getERModel() {
        return (RelationalERModel) getSimulation();
    }
    
    protected DiagramFigure createDiagramFigure(SimulatedElement simElem) {
        switch (simElem.getSimulatedConcept()) {
            case RelationalERModel.ENTITY : {
                EntityFigure f = new EntityFigure();
                f.setModel((Entity) simElem);
                return f;
            }
            case RelationalERModel.RELATIONSHIP : {
                RelationshipFigure f = new RelationshipFigure();
                f.setModel((Relationship) simElem);
                return f;
            }
            default :
                return null;
        }
    }
}
